#include <iostream>
#include <stack>
#include <string>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;

#define PI 3.1415926535897932384626433832795

const int INF = 1e9;
const ll LINF = 1e18;

const ll MOD = 1000000007;
const ll FMOD = 998244353;

const ld eps = 1e-9;

bool isOpening(string tag) {
  if (tag[1] == '/') {
    return false;
  }

  return true;
}

int main() {
  ios_base::sync_with_stdio(NULL);
  cin.tie(NULL);
  cout.tie(NULL);

  string s;
  cin >> s;
  stack<string> opening_tags;

  bool flag = true;
  while (true) {
    int first = s.find("<");

    if (first == string::npos || first != 0) {
      flag = false;
      break;
    }

    string tag = "";

    int i;
    for (i = first; i < s.size() && s[i] != '>'; i++) {
      tag += s[i];
    }
    if (s[i] == '>') {
      tag += ">";
    }

    // cout << tag << "\n";

    if (isOpening(tag)) {
      opening_tags.push(tag);
    } else {
      if (tag.size() < 4) {
        flag = false;
        break;
      }

      string without_closing = tag.substr(0, 1) + tag.substr(2, tag.size());
      if (opening_tags.top() == without_closing) {
        opening_tags.pop();
      } else {
        flag = false;
        break;
      }
    }

    if (i >= s.size() - 2) {
      break;
    } else {
      s = s.substr(i + 1, s.size() - i);
    }
  }

  if (flag) {
    cout << "Yes";
  } else {
    cout << "No";
  }

  return 0;
}
